# Copyright 2020 Autodesk, Inc.  All rights reserved.
#
# Use of this software is subject to the terms of the Autodesk license
# agreement provided at the time of installation or download, or which
# otherwise accompanies this software in either electronic or hard copy form.

from ctypes import *
from .arnold_common import ai, NullToNone
from .ai_node_entry import *
from .ai_types import *

class AtParamValueMap(Structure):
   pass

_AiParamValueMap = ai.AiParamValueMap
_AiParamValueMap.restype = c_void_p

def AiParamValueMap():
   return NullToNone(_AiParamValueMap(), POINTER(AtParamValueMap))

AiParamValueMapDestroy = ai.AiParamValueMapDestroy
AiParamValueMapDestroy.argtypes = [POINTER(AtParamValueMap)]

_AiParamValueMapGetIterator = ai.AiParamValueMapGetIterator
_AiParamValueMapGetIterator.argtypes = [POINTER(AtParamValueMap)]
_AiParamValueMapGetIterator.restype = c_void_p

def AiParamValueMapGetIterator(mds):
   return NullToNone(_AiParamValueMapGetIterator(mds), POINTER(AtParamValueMapIterator))

AiParamValueMapSetBool = ai.AiParamValueMapSetBool
AiParamValueMapSetBool.argtypes = [POINTER(AtParamValueMap), AtString, c_bool]

AiParamValueMapSetInt = ai.AiParamValueMapSetInt
AiParamValueMapSetInt.argtypes = [POINTER(AtParamValueMap), AtString, c_int]

AiParamValueMapSetFlt = ai.AiParamValueMapSetFlt
AiParamValueMapSetFlt.argtypes = [POINTER(AtParamValueMap), AtString, c_float]

AiParamValueMapSetVec = ai.AiParamValueMapSetVec
AiParamValueMapSetVec.argtypes = [POINTER(AtParamValueMap), AtString, AtVector]

AiParamValueMapSetVec2 = ai.AiParamValueMapSetVec2
AiParamValueMapSetVec2.argtypes = [POINTER(AtParamValueMap), AtString, AtVector2]

AiParamValueMapSetRGB = ai.AiParamValueMapSetRGB
AiParamValueMapSetRGB.argtypes = [POINTER(AtParamValueMap), AtString, AtRGB]

AiParamValueMapSetStr = ai.AiParamValueMapSetStr
AiParamValueMapSetStr.argtypes = [POINTER(AtParamValueMap), AtString, AtString]

AiParamValueMapGetBool = ai.AiParamValueMapGetBool
AiParamValueMapGetBool.argtypes = [POINTER(AtParamValueMap), AtString, POINTER(c_bool)]
AiParamValueMapGetBool.restype = c_bool

AiParamValueMapGetInt = ai.AiParamValueMapGetInt
AiParamValueMapGetInt.argtypes = [POINTER(AtParamValueMap), AtString, POINTER(c_int)]
AiParamValueMapGetInt.restype = c_bool

AiParamValueMapGetFlt = ai.AiParamValueMapGetFlt
AiParamValueMapGetFlt.argtypes = [POINTER(AtParamValueMap), AtString, POINTER(c_float)]
AiParamValueMapGetFlt.restype = c_bool

AiParamValueMapGetVec = ai.AiParamValueMapGetVec
AiParamValueMapGetVec.argtypes = [POINTER(AtParamValueMap), AtString, POINTER(AtVector)]
AiParamValueMapGetVec.restype = c_bool

AiParamValueMapGetVec2 = ai.AiParamValueMapGetVec2
AiParamValueMapGetVec2.argtypes = [POINTER(AtParamValueMap), AtString, POINTER(AtVector2)]
AiParamValueMapGetVec2.restype = c_bool

AiParamValueMapGetRGB = ai.AiParamValueMapGetRGB
AiParamValueMapGetRGB.argtypes = [POINTER(AtParamValueMap), AtString, POINTER(AtRGB)]
AiParamValueMapGetRGB.restype = c_bool

AiParamValueMapGetStr = ai.AiParamValueMapGetStr
AiParamValueMapGetStr.argtypes = [POINTER(AtParamValueMap), AtString, POINTER(AtStringStruct)]
AiParamValueMapGetStr.restype = c_bool
